<?php
/*--------------------------------------------------------------------------------------------------
    RepositoryInterface.php 2020-3-19
    Gambio GmbH
    http://www.gambio.de
    Copyright (c) 2016 Gambio GmbH
    Released under the GNU General Public License (Version 2)
    [http://www.gnu.org/licenses/gpl-2.0.html]
    --------------------------------------------------------------------------------------------------
 */

namespace Gambio\Shop\Attributes\SellingUnitQuantitiy\Database\Repository;


use Gambio\Shop\Attributes\ProductModifiers\Database\ValueObjects\AttributeModifierIdentifier;
use Gambio\Shop\Product\ValueObjects\ProductId;
use Gambio\Shop\SellingUnit\Unit\ValueObjects\ModifierQuantityInterface;
use ProductDataInterface;

interface RepositoryInterface
{
    /**
     * @param ProductId $productId
     * @param AttributeModifierIdentifier $modifierId
     * @param ProductDataInterface $product
     * @return mixed
     */
    public function getQuantity(
        ProductId $productId,
        AttributeModifierIdentifier $modifierId,
        ProductDataInterface $product
    ): ?ModifierQuantityInterface;

}